 ; Ŀ
 ;   Idle - try to erase all clouds and all Rev triangles.                 
 ;   Copyright 1994, 1997, 2001, 2008 by Rocket Software Ltd.              
 ;   Just ease back on the revs there, Bob.                                
 ; 

 ; Ŀ
 ;   Isc: Cloud test.                                                      
 ;   Calls Ficl.                                                           
 ; 
 (defun c:isc ()
  (if (ficl (car (entsel "Cloud to test: ")))
      (prompt "That was a cloud.")
      (prompt "That was not a cloud."))
 (princ))
 ; Ŀ
 ;   Isc end.                                                              
 ; 

 ; Ŀ
 ;   Ficl - see if a polyline is a cloud - all segments have bulges.       
 ;   Arguments: Enam, a polyline or lwpolyline entity name.                
 ;   Returns t if it's a cloud, else nil.                                  
 ; 
 (DEFUN FICL (enam / typ entt num nobulg flat sub)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (cond ((= typ "POLYLINE")
         (setq segs 0)
         (while (and (null nobulg)
                     (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq enam
                                                         (entnext enam))))))))
                (setq segs (1+ segs))
                (if (or (not (assoc 42 entt))
                        (= (cdr (assoc 42 entt)) 0))
                    (setq nobulg T))))
        ((= typ "LWPOLYLINE")
         (setq num 0)
         (setq segs 0)
         (while (and (null nobulg)
                     (setq sub (nth num entt)))
                (setq num (1+ num))
                (cond ((= (car sub) 10)
                       (setq segs (1+ segs))
                       (if flat
                           (setq nobulg t)
                           (setq flat t)))
                      ((and (= (car sub) 42)
                            (/= (cdr sub) 0))
                       (setq flat nil))))))
 ; Ŀ
 ;   If Nobulg is not set and there were > 2 segments, it was a cloud.     
 ;   Two segments with equal bulges may be a polyline circle.              
 ; 
 (and (null nobulg) (> segs 2)))
 ; Ŀ
 ;   Ficl end.                                                             
 ; 

 ; Ŀ
 ;   Idle.                                                                 
 ; 
 (DEFUN C:IDLE (/ ss enam num cnum)
  (setvar "cmdecho" 0)
  (if (setq ss (ssget "X" '((-4 . "<or") (0 . "polyline")
                                         (0 . "lwpolyline") (-4 . "or>"))))
      (progn
           (setq num 0)
           (setq cnum 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (if (ficl enam)
                      (progn
                           (setq cnum (1+ cnum))
                           (entdel enam))))
           (prompt (strcat "\nClouds Erased: " (itoa cnum)))))
  (if (setq ss (ssget "X" (list (cons 2 "rev,revtri,revision"))))
      (progn
           (prompt (strcat "\nRev Triangles Erased: " (itoa (sslength ss))))
           (command "erase" ss "")))
 (princ))